import { Link, useLocation } from 'react-router-dom'
import { motion } from 'framer-motion'
import { Music } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app-wrapper-sound">
      <header className="header-sound">
        <div className="container">
          <div className="header-content-sound">
            <Link to="/" className="logo-sound">
              <div className="logo-icon-sound">
                <Music size={28} strokeWidth={2.5} />
              </div>
              <span className="logo-text-sound">SoundRent</span>
            </Link>
            <nav className="nav-sound">
              <Link 
                to="/" 
                className={`nav-link-sound ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои аренды
              </Link>
              <Link 
                to="/rent" 
                className={`nav-link-sound ${location.pathname === '/rent' ? 'active' : ''}`}
              >
                Арендовать
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main-content-sound">
        {children}
      </main>

      <Footer />
    </div>
  )
}

export default Layout

